/*
    BCU SDK bcu development enviroment
    Copyright (C) 2005 Martin Kgler <mkoegler@auto.tuwien.ac.at>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "check.h"
#include "readconfig.h"
#include "xmlwriteappinfo.h"
#include "xmlreadconfig.h"
#include "write.h"
#include "gencode.h"
#include <stdio.h>

int
main (int ac, char *ag[])
{
  FILE *f;
  if (ac != 6)
    die ("Usage: %s config devivedesc hfile asmfile variant", ag[0]);

  Device *d = ReadConfig (ag[1]);
  if (!d)
    die ("Read failed");
  xmlReadConfigInformation (*d, ag[2]);

  CheckDevice (*d);

  f = fopen (ag[4], "w");
  if (!f)
    die (_("writing to %s failed"), ag[4]);
  GenRealAsm (f, *d);
  fclose (f);

  f = fopen (ag[3], "w");
  if (!f)
    die (_("writing to %s failed"), ag[3]);
  GenRealHeader (f, *d);
  fclose (f);

  f = fopen (ag[5], "w");
  if (!f)
    die (_("writing to %s failed"), ag[5]);
  fprintf (f, "%s", GetVariant (*d) ());
  fclose (f);

  delete d;
  return 0;
}
