/* Copyright (C) 2006 Martin Koegler
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#include <rfb/CSecurityFactory.h>

using namespace rfb;

StringParameter
CSecurityFactory::sec_types
  ("SecurityTypes",
   "Specify which security scheme to use for incoming connections (None, VncAuth)",
   "");

void
CSecurityFactory::addCSecType (rdr::U32 secType)
{
  secTypes.push_back (secType);
}

void
CSecurityFactory::getSecTypes (std::list < rdr::U32 > *sectypes,
			       bool & clientOrder)
{
  CharArray secTypesStr;
  secTypesStr.buf = sec_types.getData ();
  if (*secTypesStr.buf)
    {
      clientOrder = true;
      std::list < int >configured = parseSecTypesAdv (secTypesStr.buf);
      std::list < int >::iterator i;
      std::list < rdr::U32 >::iterator it;
      for (i = configured.begin (); i != configured.end (); i++)
	for (it = secTypes.begin (); it != secTypes.end (); it++)
	  if (*i == *it)
	    sectypes->push_back (*i);
    }
  else
    {
      clientOrder = false;
      *sectypes = secTypes;
    }
}
