/* Copyright (C) 2006 Martin Koegler
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */
#ifndef __RFB_CSECURITYFACTORY_H__
#define __RFB_CSECURITYFACTORY_H__

#include <rfb/CSecurity.h>
#include <rdr/types.h>
#include <rfb/advsecTypes.h>
#include <rfb/Configuration.h>

namespace rfb
{

  class CSecurityFactory
  {
  public:
    virtual ~ CSecurityFactory ()
    {
    }
    virtual CSecurity *getCSecurity (rdr::U32 secType) = 0;
    virtual void getSecTypes (std::list < rdr::U32 > *secTypes,
			      bool & clientOrder);
    static StringParameter sec_types;
  protected:
      std::list < rdr::U32 > secTypes;
    void addCSecType (rdr::U32 secType);
  };
}
#endif
