/* Copyright (C) 2005 Martin Kgler
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

package rfb;

public class CSecurityPlain extends CSecurity
{

  public CSecurityPlain (UserPasswdGetter upg_)
  {
    upg = upg_;
  }

  public int processMsg (CConnection cc)
  {
    rdr.OutStream os = cc.getOutStream ();

    StringBuffer passwd = new StringBuffer ();
    StringBuffer uname = new StringBuffer ();
    if (!upg.getUserPasswd (uname, passwd))
      {
	return 0;
      }
    os.writeU32 (uname.toString ().length ());
    os.writeU32 (passwd.toString ().length ());
    os.writeBytes (uname.toString ().getBytes (), 0,
		   uname.toString ().length ());
    os.writeBytes (passwd.toString ().getBytes (), 0,
		   passwd.toString ().length ());
    os.flush ();
    return 1;
  }

  public int getType ()
  {
    return advSecTypes.Plain;
  }

  UserPasswdGetter upg;

  public String description ()
  {
    return "Plain";
  }
}
