/* Copyright (C) 2002-2005 RealVNC Ltd.  All Rights Reserved.
 * Copyright (C) 2006 Martin Koegler
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#include <rfb/CSecuritySelect.h>
#include <rfb/CConnection.h>
#include <rfb/Exception.h>

#include <rfb/LogWriter.h>

using namespace rfb;

static LogWriter vlog("CSecuritySelect");

CSecuritySelect::CSecuritySelect(CSecurityFactory* Factory)
{
  real=0;
  state=0;
  factory=Factory;
}

CSecuritySelect::~CSecuritySelect()
{
  if(real)
    delete real;
}

int CSecuritySelect::getType() const
{
  if(real)
    return real->getType();
  else
    return secTypeSelect;
}

const char* CSecuritySelect::description() const
{
  if(real)
    return real->description();
  else
    return "advanced security type selection";
}

bool CSecuritySelect::processMsg(CConnection* cc)
{
  rdr::OutStream* os=cc->getOutStream();
  rdr::InStream* is=cc->getInStream();

  if(state==0)
    {
      if(!is->checkNoWait(4))
	return false;
      count=is->readU32();
      state=1;
    }
  if(state==1)
    {
      bool clientorder;
      rdr::U32 j;
      rdr::U32 secType=secTypeInvalid,secTypePos=0xFFFFFFFF;

      if(!is->checkNoWait(4*count))
	return false;

      std::list<rdr::U32> secTypes;
      std::list<rdr::U32>::iterator it;
      factory->getSecTypes(&secTypes, clientorder);

      for (int i = 0; i < count; i++)
      {
	rdr::U32 serverSecType = is->readU32();

      if (secType == secTypeInvalid || clientorder) {
	for (j=0,it=secTypes.begin(); it!=secTypes.end(); j++,it++)
          if (*it == serverSecType && j < secTypePos) {
            secType = *it;
            secTypePos = j;
            break;
	  }
      }
      }

    if (secType != secTypeInvalid) {
      os->writeU32(secType);
      os->flush();
      vlog.debug("Choosing advanced security type %s(%d)",secTypeNameAdv(secType),secType);
      }
    else
      throw AuthFailureException("No common security type");
    real=factory->getCSecurity(secType);
    state=2;
    }

  if(real)
    return real->processMsg(cc);
  else
    throw AuthFailureException("No selected security type");
}

