/* Copyright (C) 2006 Martin Koegler <mkoegler@auto.tuwien.ac.at>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */
package rfb;

import java.util.ArrayList;

public class CSecuritySelect extends CSecurity
{

  public CSecuritySelect (CSecurityFactory Factory)
  {
    factory = Factory;
  }

  public int getType ()
  {
    if (real == null)
      return SecTypes.Select;
    else
      return real.getType ();
  }
  public String description ()
  {
    if (real == null)
      return "advanced security type selection";
    else
      return real.description ();
  }

  public int processMsg (CConnection cc)
  {
    rdr.OutStream os = cc.getOutStream ();
    rdr.InStream is = cc.getInStream ();

    int count = is.readU32 ();

    ArrayList secTypes = new ArrayList ();
    boolean clientOrder = factory.getSecTypes (secTypes);

    int j;
    int secType = SecTypes.none;
    long secTypePos = 0xFFFFFFFF;

    for (int i = 0; i < count; i++)
      {
	int serverSecType = is.readU32 ();

	if (secType == SecTypes.none || clientOrder)
	  {
	    for (j = 0; j < secTypes.size (); j++)
	      if (((Integer) secTypes.get (i)).intValue () == serverSecType
		  && j < secTypePos)
		{
		  secType = ((Integer) secTypes.get (i)).intValue ();
		  secTypePos = j;
		  break;
		}
	  }
      }

    if (secType != SecTypes.none)
      {
	os.writeU32 (secType);
	os.flush ();
      }
    else
      throw new AuthFailureException ("No common security type");
    real = factory.getCSecurity (secType);

    if (real != null)
      return real.processMsg (cc);
    else
      throw new AuthFailureException ("No selected security type");
  }

  private CSecurityFactory factory;
  private CSecurity real;
}
