/* Copyright (C) 2005 Martin Koegler
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#include <rfb/CSecurityStack.h>

using namespace rfb;

CSecurityStack::CSecurityStack(int Type,const char*Name,CSecurity* s0,CSecurity* s1,CSecurity* s2,CSecurity* s3)
  :name(Name),type(Type)
{
  state=0;
  state0=s0;
  state1=s1;
  state2=s2;
  state3=s3;
}

CSecurityStack::~CSecurityStack()
{
  if(state0)
    delete state0;
  if(state1)
    delete state1;
  if(state2)
    delete state2;
  if(state3)
    delete state3;
}

bool CSecurityStack::processMsg(CConnection* cc)
{
  bool res=true;
  if(state==0)
    {
      if(state0)
	res=state0->processMsg(cc);
      if(!res)
	return res;
      state++;
    }
  if(state==1)
    {
      if(state1)
	res=state1->processMsg(cc);
      if(!res)
	return res;
      state++;
    }
  if(state==2)
    {
      if(state2)
	res=state2->processMsg(cc);
      if(!res)
	return res;
      state++;
    }
  if(state==3)
    {
      if(state3)
	res=state3->processMsg(cc);
      if(!res)
	return res;
      state++;
    }
  return res;
}
