/* Copyright (C) 2005 Martin Koegler  All Rights Reserved.
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */
package rfb;

public class CSecurityStack extends CSecurity
{
  String name;
  int type;
  int state;
  CSecurity state0;
  CSecurity state1;
  CSecurity state2;
  CSecurity state3;

  public CSecurityStack (int Type, String Name, CSecurity s0, CSecurity s1,
			 CSecurity s2, CSecurity s3)
  {
    state = 0;
    type = Type;
    name = Name;
    state0 = s0;
    state1 = s1;
    state2 = s2;
    state3 = s3;
  }

  public int processMsg (CConnection cc)
  {
    int result = 1;
    if (state == 0)
      {
	if (state0 != null)
	  result = state0.processMsg (cc);
	if (result != 1)
	  return result;
	state++;
      }
    if (state == 1)
      {
	if (state1 != null)
	  result = state1.processMsg (cc);
	if (result != 1)
	  return result;
	state++;
      }
    if (state == 1)
      {
	if (state1 != null)
	  result = state1.processMsg (cc);
	if (result != 1)
	  return result;
	state++;
      }
    if (state == 2)
      {
	if (state2 != null)
	  result = state2.processMsg (cc);
	if (result != 1)
	  return result;
	state++;
      }
    if (state == 3)
      {
	if (state3 != null)
	  result = state3.processMsg (cc);
	if (result != 1)
	  return result;
	state++;
      }
    return result;
  }
  public int getType ()
  {
    return type;
  }
  public String description ()
  {
    return name;
  }
}
