/*
 * Copyright (C) 2003 Sun Microsystems, Inc.
 * Copyright (C) 2003 Martin Kgler
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

package rfb;

import java.util.ArrayList;
import java.net.*;
import javax.net.ssl.*;

public abstract class CSecurityTLSBase extends CSecurity
{

  public CSecurityTLSBase (Socket sock_)
  {
    sock = sock_;
  }

  protected void initContext (SSLContext sc) throws java.security.
    GeneralSecurityException
  {
    sc.init (null, null, null);
  }

  public int processMsg (CConnection cc)
  {
    if (cc.getInStream ().readU8 () == 0)
      return 1;
    try
    {
      SSLSocketFactory sslfactory;
      SSLSocket sslsock;
      SSLContext sc = SSLContext.getInstance ("TLS");
      initContext (sc);
      sslfactory = sc.getSocketFactory ();
      sslsock = (SSLSocket) sslfactory.createSocket (sock,
						     sock.getInetAddress ().
						     getHostName (),
						     sock.getPort (), true);

      setParam (sslsock);

      /* Not neccessary - just ensures that we know what cipher
       * suite we are using for the output of toString()
       */
      sslsock.startHandshake ();

      tlog.debug ("Completed handshake with server " + sslsock.toString ());

      cc.setStreams (new rdr.JavaInStream (sslsock.getInputStream ()),
		     new rdr.JavaOutStream (sslsock.getOutputStream ()));

      return 1;
    }
    catch (java.io.IOException e)
    {
      tlog.error ("TLS handshake failed " + e.toString ());
      return 0;
    }
    catch (java.security.GeneralSecurityException e)
    {
      tlog.error ("TLS handshake failed " + e.toString ());
      return 0;
    }
  }


  protected abstract void setParam (SSLSocket sock);

  Socket sock;

  static LogWriter tlog = new LogWriter ("TLS");
}
