/* Copyright (C) 2002-2005 RealVNC Ltd.  All Rights Reserved.
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#include <rfb/advsecTypes.h>
#include <rfb/SSecurityNone.h>
#include <rfb/Configuration.h>
#include <rfb/LogWriter.h>
#include <rfb/Exception.h>
#include <rfb/SSecurityFactoryStandard.h>
#include <rfb/SSecurityFactoryAdvancedBase.h>
#include <rfb/Password.h>

using namespace rfb;

static LogWriter vlog ("SSecurityFactoryAdvancedBase");

SSecurity *
SSecurityFactoryAdvancedBase::getSSecurity (rdr::U32 secType,
					    bool reverseConnection)
{
  switch (secType)
    {
    case secTypeNone:
      return new SSecurityNone ();
    case secTypeVncAuth:
      return new SSecurityVncAuth (&SSecurityFactoryStandard::vncAuthPasswd);
    default:
      throw Exception ("Security type not supported");
    }
}

void
SSecurityFactoryAdvancedBase::getSecTypes (std::list < rdr::U32 > *secTypes,
					   bool reverseConnection)
{
  CharArray secTypesStr;
  if (reverseConnection)
    secTypesStr.buf = SSecurityFactoryStandard::rev_sec_types.getData ();
  else
    secTypesStr.buf = SSecurityFactoryStandard::sec_types.getData ();
  std::list < int >configured = parseSecTypesAdv (secTypesStr.buf);
  std::list < int >::iterator i;
  for (i = configured.begin (); i != configured.end (); i++)
    {
      if (isSecTypeSupported (*i))
	secTypes->push_back (*i);
    }
}

bool
SSecurityFactoryAdvancedBase::isSecTypeSupported (rdr::U32 secType)
{
  switch (secType)
    {
    case secTypeNone:
    case secTypeVncAuth:
      return true;
    default:
      return false;
    }
}
