/* 
 * Copyright (C) 2005 Martin Koegler
 *    
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#include <rfb/SSecurityFactoryAdvancedTLS.h>
#include <rfb/SSecurityPlain.h>
#include <rfb/SSecurityTLS.h>
#include <rfb/SSecurityX509.h>
#include <rfb/SSecurityStack.h>
#include <rfb/Configuration.h>

using namespace rfb;

#ifdef HAVE_GNUTLS

StringParameter
SSecurityFactoryAdvancedTLS::X509_CertFile
  ("x509cert", "specifies path to the x509 certificate in PEM format", "");

StringParameter
SSecurityFactoryAdvancedTLS::X509_KeyFile
  ("x509key",
   "specifies path to the key of the x509 certificate in PEM format", "");

#endif

class
  Valid:
  public
  PasswordValidator
{
public:
  bool
  validate (SConnection * sc, const char *username, const char *password)
  {
    if (*username == *password)
      return true;
    else
      return
	false;
  }
};
static Valid
  defvalid;

SSecurity *
SSecurityFactoryAdvancedTLS::getSSecurity (rdr::U32 secType, bool reverse)
{
  switch (secType)
    {
#ifdef HAVE_GNUTLS
      /* Test:
         case secAdvTypePlain:
         return new SSecurityPlain(&defvalid);
       */
    case secAdvTypeTLSNone:
      return new SSecurityTLS ();
    case secAdvTypeTLSVnc:
      return new SSecurityStack (secAdvTypeTLSVnc,
				 getSSecurity (secAdvTypeTLSNone, reverse),
				 getSSecurity (secTypeVncAuth, reverse));
    case secAdvTypeTLSPlain:
      return new SSecurityStack (secAdvTypeTLSPlain,
				 getSSecurity (secAdvTypeTLSNone, reverse),
				 getSSecurity (secAdvTypePlain, reverse));
    case secAdvTypeX509None:
      return new SSecurityX509 (X509_CertFile.getData (),
				X509_KeyFile.getData ());
    case secAdvTypeX509Vnc:
      return new SSecurityStack (secAdvTypeX509Vnc,
				 getSSecurity (secAdvTypeX509None, reverse),
				 getSSecurity (secTypeVncAuth, reverse));
    case secAdvTypeX509Plain:
      return new SSecurityStack (secAdvTypeX509Vnc,
				 getSSecurity (secAdvTypeX509None, reverse),
				 getSSecurity (secAdvTypePlain, reverse));
#endif
    default:
      return SSecurityFactoryAdvancedBase::getSSecurity (secType, reverse);
    }
}
bool
SSecurityFactoryAdvancedTLS::isSecTypeSupported (rdr::U32 secType)
{
  switch (secType)
    {
#ifdef HAVE_GNUTLS
    case secAdvTypePlain:
    case secAdvTypeTLSNone:
    case secAdvTypeTLSVnc:
    case secAdvTypeTLSPlain:
    case secAdvTypeX509None:
    case secAdvTypeX509Vnc:
    case secAdvTypeX509Plain:
#endif
      return true;
    default:
      return SSecurityFactoryAdvancedBase::isSecTypeSupported (secType);
    }
}
