/* 
 * Copyright (C) 2005 - 2006 Martin Koegler
 *    
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#include <rfb/SSecurityFactoryTLS.h>
#include <rfb/SSecurityFactoryAdvancedTLS.h>
#include <rfb/SSecurityPlain.h>
#include <rfb/SSecurityTLS.h>
#include <rfb/SSecurityX509.h>
#include <rfb/SSecurityStack.h>
#include <rfb/Configuration.h>

using namespace rfb;

static SSecurityFactoryAdvancedTLS TLSFactory;

SSecurityFactoryTLS::SSecurityFactoryTLS ():SSecurityFactorySelect
  (&TLSFactory)
{
}

SSecurity *
SSecurityFactoryTLS::getSSecurity (rdr::U8 secType, bool reverse)
{
  switch (secType)
    {
    default:
      return SSecurityFactorySelect::getSSecurity (secType, reverse);
    }
}
bool
SSecurityFactoryTLS::isSecTypeSupported (rdr::U8 secType)
{
  switch (secType)
    {
      return true;
    default:
      return SSecurityFactorySelect::isSecTypeSupported (secType);
    }
}
