/* Copyright (C) 2006 Martin Koegler
 * Copyright (C) 2002-2005 RealVNC Ltd.  All Rights Reserved.
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#include <rfb/SSecuritySelect.h>
#include <rfb/Exception.h>
#include <rfb/SConnection.h>

using namespace rfb;

SSecuritySelect::SSecuritySelect(SSecurityFactoryAdvanced* Factory,bool reverseConnection)
{
  real=0;
  state=0;
  factory=Factory;
  reverse=reverseConnection;
}


SSecuritySelect::~SSecuritySelect()
{
  if(real)
    delete real;
}

int SSecuritySelect::getType() const 
{
  if(real)
    return real->getType();
  else
    return secTypeSelect;
}
const char* SSecuritySelect::getUserName() const
{
  if(real)
    return real->getUserName();
  else
    return 0;
}

bool SSecuritySelect::processMsg(SConnection* cc)
{
  rdr::OutStream* os=cc->getOutStream();
  rdr::InStream* is=cc->getInStream();

  if(state==0)
    {
      std::list<rdr::U32> secTypes;
      std::list<rdr::U32>::iterator i;
      factory->getSecTypes(&secTypes, reverse);
      
      os->writeU32(secTypes.size());
      for (i=secTypes.begin(); i!=secTypes.end(); i++)
	os->writeU32(*i);
      os->flush();
      state=1;
    }
  if(state==1)
    {
      int secType;
      if(!is->checkNoWait(4))
	return false;
      secType=is->readU32();
      state=3;
      try {
	real = factory->getSSecurity(secType, reverse);
      } catch (rdr::Exception& e) {
	throw AuthFailureException(e.str());
      }
    }
  if(real)
    return real->processMsg(cc);
  else
	throw AuthFailureException("No security type");
}
