/* Copyright (C) 2005 Martin Koegler
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#include <rfb/SSecurityStack.h>

using namespace rfb;

SSecurityStack::SSecurityStack(int Type,SSecurity* s0,SSecurity* s1,SSecurity* s2,SSecurity* s3)
  :type(Type)
{
  state=0;
  state0=s0;
  state1=s1;
  state2=s2;
  state3=s3;
}

SSecurityStack::~SSecurityStack()
{
  if(state0)
    delete state0;
  if(state1)
    delete state1;
  if(state2)
    delete state2;
  if(state3)
    delete state3;
}

bool SSecurityStack::processMsg(SConnection* cc)
{
  bool res=true;
  if(state==0)
    {
      if(state0)
	res=state0->processMsg(cc);
      if(!res)
	return res;
      state++;
    }
  if(state==1)
    {
      if(state1)
	res=state1->processMsg(cc);
      if(!res)
	return res;
      state++;
    }
  if(state==2)
    {
      if(state2)
	res=state2->processMsg(cc);
      if(!res)
	return res;
      state++;
    }
  if(state==3)
    {
      if(state3)
	res=state3->processMsg(cc);
      if(!res)
	return res;
      state++;
    }
  return res;
}

const char* SSecurityStack::getUserName() const
{
  const char* c=0;
  if(state3 && !c)
    c=state3->getUserName();
  if(state2 && !c)
    c=state2->getUserName();
  if(state1 && !c)
    c=state1->getUserName();
  if(state0 && !c)
    c=state0->getUserName();
  return c;
}
