/* 
 * Copyright (C) 2005 Martin Koegler
 *    
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#ifndef __S_SECURITY_X509_H__
#define __S_SECURITY_X509_H__

#ifdef HAVE_GNUTLS

#include <rfb/advsecTypes.h>
#include <rfb/SSecurityTLSBase.h>

namespace rfb {

  class SSecurityX509 : public SSecurityTLSBase {
  public:
    SSecurityX509(char* certfile, char* keyfile);
    virtual ~SSecurityX509();
    virtual int getType() const {return secAdvTypeX509None;}

  protected:
    virtual void freeResources();
    virtual void setParams(gnutls_session session);
    virtual void checkSession(gnutls_session session);

  private:
    static void initGlobal();

    gnutls_dh_params dh_params;
    gnutls_certificate_credentials cert_cred;
    char* keyfile;
    char* certfile;
  };

}

#endif /* HAVE_GNUTLS */

#endif /* __S_SECURITY_TLS_H__ */
