/* Copyright (C) 2002-2005 RealVNC Ltd.  All Rights Reserved.
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */
//
// SecTypes.java - constants for the various security types.
//

package rfb;

import java.util.ArrayList;

public class advSecTypes
{
  public static final int Plain = 256;
  public static final int TLSNone = 257;
  public static final int TLSVnc = 258;
  public static final int TLSPlain = 259;
  public static final int X509None = 260;
  public static final int X509Vnc = 261;
  public static final int X509Plain = 262;


  public static String name (int num)
  {
    switch (num)
      {
      case Plain:
	return "Plain";
	case TLSNone:return "TLSNone";
	case TLSVnc:return "TLSVnc";
	case TLSPlain:return "TLSPlain";
	case X509None:return "X509None";
	case X509Vnc:return "X509Vnc";
	case X509Plain:return "X509Plain";
	default:return SecTypes.name (num);
      }
  }
  public static int num (String name)
  {
    if (name.equalsIgnoreCase ("Plain"))
      return Plain;
    if (name.equalsIgnoreCase ("TLSNone"))
      return TLSNone;
    if (name.equalsIgnoreCase ("TLSVnc"))
      return TLSVnc;
    if (name.equalsIgnoreCase ("TLSPlain"))
      return TLSPlain;
    if (name.equalsIgnoreCase ("X509None"))
      return X509None;
    if (name.equalsIgnoreCase ("X509Vnc"))
      return X509Vnc;
    if (name.equalsIgnoreCase ("X509Plain"))
      return X509Plain;
    return SecTypes.num (name);
  }
  ArrayList parseSecTypes (String types)
  {
    String[]type = types.split (",");
    int SecType;
    ArrayList l = new ArrayList ();
    for (int i = 0; i < type.length; i++)
      {
	SecType = num (type[i]);
	if (SecType != SecTypes.none)
	  l.add (new Integer (SecType));
      }
    return l;
  }
}
