/* Copyright (C) 2002-2005 RealVNC Ltd.  All Rights Reserved.
 * Copyright (C) 2006 Martin Kgler <mkoegler@auto.tuwien.ac.at>
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */
#include <string.h>
#ifdef _WIN32
#define strcasecmp _stricmp
#endif
#include <rfb/advsecTypes.h>
#include <rfb/util.h>

int rfb::secTypeNumAdv(const char* name)
{
  if (strcasecmp(name, "Plain") == 0)        return secAdvTypePlain;
  if (strcasecmp(name, "TLSNone") == 0)      return secAdvTypeTLSNone;
  if (strcasecmp(name, "TLSVnc") == 0)       return secAdvTypeTLSVnc;
  if (strcasecmp(name, "TLSPlain") == 0)     return secAdvTypeTLSPlain;
  if (strcasecmp(name, "X509None") == 0)     return secAdvTypeX509None;
  if (strcasecmp(name, "X509Vnc") == 0)      return secAdvTypeX509Vnc;
  if (strcasecmp(name, "X509Plain") == 0)    return secAdvTypeX509Plain;
  return secTypeNum(name);
}

const char* rfb::secTypeNameAdv(int num)
{
  switch (num) {
  case secAdvTypePlain:      return "Plain";
  case secAdvTypeTLSNone:    return "TLSNone";
  case secAdvTypeTLSVnc:     return "TLSVnc";
  case secAdvTypeTLSPlain:   return "TLSPlain";
  case secAdvTypeX509None:   return "X509None";
  case secAdvTypeX509Vnc:    return "X509Vnc";
  case secAdvTypeX509Plain:  return "X509Plain";
  default:                return secTypeName(num);
  }
}

bool rfb::secTypeEncryptsAdv(int num)
{
  switch (num) {
  case secAdvTypeTLSNone:
  case secAdvTypeTLSVnc:
  case secAdvTypeTLSPlain:
  case secAdvTypeX509None:
  case secAdvTypeX509Vnc:
  case secAdvTypeX509Plain:
    return true;
  default:
    return secTypeEncrypts(num);
  }
}

std::list<int> rfb::parseSecTypesAdv(const char* types_)
{
  std::list<int> result;
  CharArray types(strDup(types_)), type;
  while (types.buf) {
    strSplit(types.buf, ',', &type.buf, &types.buf);
    int typeNum = secTypeNumAdv(type.buf);
    if (typeNum != secTypeInvalid)
      result.push_back(typeNum);
  }
  return result;
}
