/* Copyright (C) 2006 Martin Kgler <mkoegler@auto.tuwien.ac.at>
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */
//
// secTypes.h - constants for the various security types.
//

#ifndef __RFB_ADVSECTYPES_H__
#define __RFB_ADVSECTYPES_H__

#include "secTypes.h"

namespace rfb {

  const int secAdvTypePlain       = 256;
  const int secAdvTypeTLSNone     = 257;
  const int secAdvTypeTLSVnc      = 258;
  const int secAdvTypeTLSPlain    = 259;
  const int secAdvTypeX509None    = 260;
  const int secAdvTypeX509Vnc     = 261;
  const int secAdvTypeX509Plain   = 262;

  const char* secTypeNameAdv(int num);
  int secTypeNumAdv(const char* name);
  bool secTypeEncryptsAdv(int num);
  std::list<int> parseSecTypesAdv(const char* types);
}

#endif
