/* Compile with gcc -Wall -O3 -o busmontest busmontest.c */

#include <unistd.h>
#include <time.h>
#include <string.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h> /* for atexit() */
#include <sys/ioctl.h> /* for ioctl() */

#include "tpuart_main.h" /* for IOCTL's */

struct message {
	struct timeval timestamp;  /* will hold the receive time */
	unsigned short length;     /* holds the message length in data */
	unsigned char data [64];   /* holds the message itself */
};

int main(int argc, char* argv[]) 
{
	unsigned short addr = 0x1109;  /* our physical address */
	struct message telegram;
	int fd;
	int i;
	int count = 0;

  
	
	/* this cleanup function is executed in case the user
	   hits Ctrl-c or something */
	void cleanup (void) { 
		close (fd);
	};

	if (argc != 2) {
		fprintf (stderr, "Usage: busmontest device\n");
		return 1;
	}
		
	/* Open the driver device file */
	fd = open (argv[1], O_RDWR);
	if (fd == -1) {
		perror ("open");
		return 1;
	}

	/* register our cleanup function */
	atexit (cleanup);

	/* set our physical address */
	ioctl (fd,TPUART_SET_PH_ADDR,&addr);

	/* switch to busmonitor mode */
	ioctl (fd,TPUART_BUSMON_ON);

	while (1) {
		/* read a message */
		if (read (fd, &telegram, sizeof (telegram)) <= 0) {
			perror ("read");
			return 1;
		}
			
		fprintf (stdout, "Seconds: %10lu\t", (unsigned long)telegram.timestamp.tv_sec);
		fprintf (stdout, "Microseconds: %10lu\n", (unsigned long)telegram.timestamp.tv_usec);
		fprintf (stdout, "Wall time: %s", ctime (&telegram.timestamp.tv_sec));
		
		fprintf (stdout, "Data length: %u\t Count:%u\n", telegram.length, count++);
		fprintf (stdout, "Data: ");
		for (i = 0; i < telegram.length; i++)
		{
			fprintf (stdout, "0x%x ", telegram.data[i]);
		}
		fprintf (stdout, "\n\n");
	
		if (count==3){
		  fprintf(stdout,"RESET\n");
		  ioctl(fd, TPUART_RESET);
		}
	}
		
	/* never reached */
	close (fd);
	return 0;
}
