/* 
 *    tpuart -- A TP-UART driver 
 *
 *
 *    File: deque.h -- telegram buffer 
 *
 *    $Id: deque.h,v 1.2 2001/05/23 11:33:49 rst Exp $
 *
 *
 *    Copyright (C) 2000 Raffael Stocker <raffael.stocker@stud.fh-deggendorf.de> 
 *                       University of applied sciences Deggendorf
 *
 *    July 2004   Porting driver to kernel 2.6
 *                Reinhold Buchinger <e0125124@student.tuwien.ac.at>
 *                University of Technology Vienna
 *
 *    This program is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU General Public License as
 *    published by the Free Software Foundation; either version 2 of the
 *    License, or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *    General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place--Suite 330, Boston, MA
 *    02111-1307, USA.
 *
 *
 *    08-Sep-2000: 0.01  Started Coding
 *
 *    Last change:
 *
 *    $Date: 2001/05/23 11:33:49 $ $Author: rst $
 *
 *    $Date: 2004/07/23 08:00:00 $ $Author: rb  $
 */

#ifndef __DEQUE
#define __DEQUE

#include <linux/types.h>
//#include <asm/spinlock.h>
 
typedef struct {
	void *buffer;
	void *head;
	void *tail;
	size_t elem_size;
	int bufsize;
	spinlock_t lock;
} deque_t;

int deque_is_full (deque_t*);
int deque_is_full_irq (deque_t*);
int deque_is_full_irqsave (deque_t*);

int deque_is_empty (deque_t*);
int deque_is_empty_irq (deque_t*);
int deque_is_empty_irqsave (deque_t*);

int deque_get (void*, deque_t*);
int deque_get_irq (void*, deque_t*);
int deque_get_irqsave (void*, deque_t*);

int deque_put (void*, deque_t*);
int deque_put_irq (void*, deque_t*);
int deque_put_irqsave (void*, deque_t*);

int deque_init (deque_t*, size_t, int);

void deque_cleanup (deque_t*);


#endif /* __DEQUE */
