 /* 
 *    tpuart -- A TP-UART driver 
 *
 *
 *    File: heartbeat.h -- function and macro definitions
 *
 *    $Id: heartbeat.h,v 1.0 2004/10/2 08:23:13 rb Exp $
 *
 *    Reinhold Buchinger <e0125124@student.tuwien.ac.at>
 *    University of Technology Vienna
 *    
 *    This program is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU General Public License as
 *    published by the Free Software Foundation; either version 2 of the
 *    License, or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *    General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place--Suite 330, Boston, MA
 *    02111-1307, USA.
 *
 *
 *    28-Sept-2004: 0.01  Started Coding
 *
 *    Last change:
 *
 */




/* function declarations */
void init_heartbeat(tpuart_t *);
void del_heartbeat(tpuart_t *);
void resetloop_request(unsigned long);
void resetloop_answer(unsigned long);
void sending_state_message(tpuart_t *);
void heartbeat(unsigned long ptr);




/*** macro definitions ***/

/*
#define queue_timer(dev,time) do{ \
    (dev)->heartbeat_timer.expires=(time);     \
    add_timer(&(dev)->heartbeat_timer);       \
  } while(0)
*/



/* restart heartbeat after yo have stopped it */
#define start_heartbeat(dev) do{		\
    if (test_bit(DEAD,&(dev)->flags)) {			     \
      (dev)->heartbeat_timer.function=resetloop_request;     \
    }else {						     \
      (dev)->heartbeat_timer.function=heartbeat;	     \
      set_bit(HB_STATE_AWAIT, &(dev)->flags);		     \
      sending_state_message(dev);			     \
      }					\
     set_bit(HEARTBEAT_ON, &(dev)->flags); \
     mod_timer(&(dev)->heartbeat_timer, jiffies+HZ*heartbeat_interval); \
} while(0)

/* stop heartbeat */
#define stop_heartbeat(dev) do{ \
 clear_bit(HEARTBEAT_ON, &(dev)->flags); \
} while(0)


		
