/* 
 *    tpuart -- A TP-UART driver 
 *
 *
 *    File: utility.h -- defines for receive state machine
 *
 *    $Id: utility.h,v 1.2 2001/05/23 11:33:49 rst Exp $
 *
 *
 *    Copyright (C) 2000 Raffael Stocker <raffael.stocker@stud.fh-deggendorf.de> 
 *                       University of applied sciences Deggendorf
 *
 *    July 2004   Porting driver to kernel 2.6
 *                Reinhold Buchinger <e0125124@student.tuwien.ac.at>
 *                University of Technology Vienna
 *
 *    This program is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU General Public License as
 *    published by the Free Software Foundation; either version 2 of the
 *    License, or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *    General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place--Suite 330, Boston, MA
 *    02111-1307, USA.
 *
 *
 *    20-Aug-2000: 0.01  Started Coding
 *
 *    Last change:
 *
 *    $Date: 2001/05/23 11:33:49 $ $Author: rst $
 *
 *    $Date: 2004/07/23 08:00:00 $ $Author: rb  $
 */ 

#ifndef __UTILITY
#define __UTILITY






#define GET_LOCK(dev)  spin_lock_irqsave(&(dev)->lock,flags);
      



#define RELEASE_LOCK(dev) spin_unlock_irqrestore(&(dev)->lock,flags);


/*
 * INSERT_GROUP_ADDR () inserts a new group address
 */
#define INSERT_GROUP_ADDR(adr, dev) do {\
         unsigned long flags;\
         GET_LOCK(dev); \
        (dev)->group_addr[(adr)>>3] |= 1 << (0x7 & (adr)); \
	 RELEASE_LOCK(dev); \
        } while (0)

/*
 * CLEAR_GROUP_ADDR () clears a group address
 */
#define CLEAR_GROUP_ADDR(adr, dev) do {\
        unsigned long flags; \
        GET_LOCK(dev); \
        (dev)->group_addr[(adr)>>3] &= ~(1 << (0x7 & (adr))); \
        RELEASE_LOCK(dev); \
	 } while (0)

/*
 * INSERT_PHYS_ADDR () inserts a new phys address
 */
#define INSERT_PHYS_ADDR(adr, dev) do {\
        unsigned long flags; \
        GET_LOCK(dev); \
        (dev)->phys_addr[(adr)>>3] |= 1 << (0x7 & (adr)); \
        RELEASE_LOCK(dev); \
         } while (0)

/*
 * CLEAR_PHYS_ADDR () clears a phys address
 */
#define CLEAR_PHYS_ADDR(adr, dev) do {\
        unsigned long flags; \
        GET_LOCK(dev); \
        (dev)->phys_addr[(adr)>>3] &= ~(1 << (0x7 & (adr))); \
        RELEASE_LOCK(dev); \
        } while (0)

/*
 * QUEUE_BH () marks a bottom half for execution.
 */
#define QUEUE_BH(task) do {\
	schedule_work ((task)); \
        } while (0)

#endif /* __UTILITY */
