/* Compile with gcc -Wall -O3 -o writetest writetest.c */

#include <unistd.h>
#include <time.h>
#include <string.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h> /* for atexit() */
#include <sys/ioctl.h> /* for ioctl() */

#include "tpuart_main.h"

/* two demonstration messages. Normally this would be generated
   dynamically. */
unsigned char data1[] = {0xbc, 0x11, 0x7, 0x0, 0x1, 0xe1, 
			  0x0, 0x80 };

unsigned char data2[] = {0xbc, 0x11, 0x7, 0x0, 0x1, 0xe1, 
			  0x0, 0x81};

struct message {
	struct timeval timestamp;
	unsigned short length;
	unsigned char data [64];
};

int main(int argc, char* argv[]) 
{ 
        unsigned short addrarr[] = {0x1107,0x1108};
	//unsigned short addr1 = 0x1107; /* first physical address */
	//unsigned short addr2 = 0x1108; /* second physical address */
	//unsigned short garr[]={0x01,0x02};
	//unsigned short graddr1=0x01;
        unsigned short graddr2=0x02;
	int ret;
	struct message telegram1;
	struct message telegram2;
	int fd;

	/* this cleanup function is executed in case the user
	   hits Ctrl-c or something */
	void cleanup (void) { 
		close (fd);
	}

	if (argc != 2) {
		fprintf (stderr, "Usage: writetest device\n");
		return 1;
	}

	/* the length of our messages */
	telegram1.length = 8;
	telegram2.length = 8;

	/* Open the driver device file */
	fd = open (argv[1], O_RDWR);
	if (fd == -1) {
		perror ("open");
		return 1;
	}
	
	/* register our cleanup function */
	atexit (cleanup);

	/* set our physical addresses */
	ret=ioctl (fd,  TPUART_SET_PH_ADDR_ARRAY, addrarr);
	//ret=ioctl (fd,  TPUART_UNSET_PH_ADDR , &addr2);
       


	//ioctl (fd, TPUART_SET_PH_ADDR, &addr2);
	
	ioctl (fd,TPUART_SET_GR_ADDR,&graddr2);
	//ioctl (fd,TPUART_UNSET_GR_ADDR,&graddr2);
	
  

	/* initialize messages */
	memset (telegram1.data, 0, 64);
	memcpy (telegram1.data, data1, telegram1.length);
	memset (telegram2.data, 0, 64);
	memcpy (telegram2.data, data2, telegram2.length);

	       
	// the following while-loop will smoke up your EIB bus... 
	while (1) {
		if (write (fd, &telegram1, sizeof (telegram1)) <= 0) {
			perror ("write1");
		}
		usleep(1000);   //wait 1 ms (just to be fair, driver can keep up with no delay) 
	
			
		if (write (fd, &telegram2, sizeof (telegram2)) <= 0) {
			perror ("write2");
		}
	       usleep(1000);
		
	       }
		
	
	/* never reached */ 
	close (fd);
	return 0;
       
}
